#include "gpio2.hh"
#include <util/delay.hh>

typedef GpioOut<port2addr(PORTB), 5> MyLed;

template <int ms>
void ledHalfCycle(MyLed led, bool on)
{
    led.set(on);
    delay_ms(ms);
}

template <int onMs, int offMs>
void ledCycle(MyLed led)
{
    ledHalfCycle<onMs>(led, true);
    ledHalfCycle<offMs>(led, false);
}

int main()
{
    MyLed led(true);

    while (1)
    {
	ledCycle<200, 200>(led);
	ledCycle<200, 200>(led);
	ledCycle<200, 200>(led);
	ledCycle<200, 500>(led);
    }
}

